/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerWorkflowPane;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWComponentStepUI;
import filenet.vw.toolkit.utils.mapui.VWGeneralStepUI;
import filenet.vw.toolkit.utils.mapui.VWLaunchStepUI;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapNodeUIToolkit;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWSubmapStepUI;
import filenet.vw.toolkit.utils.mapui.VWSystemStepUI;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class VWSIMDesignerMapPane
extends VWBaseWorkflowMapPane {
    private static final long serialVersionUID = 472L;
    private VWStepRouteColors m_stepRouteColors = new VWStepRouteColors();
    private VWMapDefinition m_mapDefinition = null;
    private VWMapNodeUIToolkit m_mapNodeUIToolkit = null;

    public VWSIMDesignerMapPane(VWSIMDesignerWorkflowPane workflowPane) {
        super(workflowPane);
        this.m_mapNodeUIToolkit = new VWMapNodeUIToolkit(workflowPane.getSessionInfo().getExternalClassLoader(), workflowPane.getMapAttributes());
    }

    public String[] getParentMapNames() {
        return ((VWSIMDesignerWorkflowPane)this.m_workflowPane).getCallerMaps(this.m_map.getName());
    }

    public void setMapDefinition(VWMap map) {
        if (map != null) {
            this.m_map = map;
            this.m_mapDefinition = map.getMapDefinition();
            this.m_steps = new Vector();
            this.m_routes = new Vector();
            this.setIsDirty(false);
            if (this.m_mapDefinition == null) {
                VWDebug.logWarning("The workflow map pane is set to display a null workflow map definition.");
            } else {
                try {
                    VWMapNode[] vwMapNodes = this.m_mapDefinition.getSteps();
                    if (vwMapNodes != null) {
                        int nIndex;
                        for (nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                            VWBaseStepUI step = null;
                            switch (VWStepUtils.getStepType(vwMapNodes[nIndex])) {
                                case 0: {
                                    step = new VWLaunchStepUI((VWStepDefinition)vwMapNodes[nIndex], this.m_mapNodeUIToolkit);
                                    step.setFocus(true);
                                    break;
                                }
                                case 14: {
                                    step = new VWComponentStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 2: 
                                case 4: 
                                case 6: {
                                    step = new VWGeneralStepUI((VWStepDefinition)vwMapNodes[nIndex], true, this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 10: {
                                    step = new VWSubmapStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 12: {
                                    step = new VWSystemStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 13: {
                                    step = new VWComponentStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: {
                                    step = new VWGeneralStepUI((VWStepDefinition)vwMapNodes[nIndex], this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 9: {
                                    step = new VWSubmapStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_mapNodeUIToolkit);
                                    break;
                                }
                                case 11: {
                                    step = new VWSystemStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_mapNodeUIToolkit);
                                }
                            }
                            if (step != null) {
                                this.m_steps.addElement(step);
                                step.addFocusListener(this);
                                continue;
                            }
                            VWDebug.logError("The step is an invalid type:" + vwMapNodes[nIndex]);
                        }
                        for (nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                            VWBaseStepUI prevStep = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                            VWRouteDefinition[] vwRoutes = prevStep.getMapNode().getNextRoutes();
                            if (vwRoutes == null) continue;
                            for (int rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                                VWBaseStepUI nextStep = this.findStep(vwRoutes[rIndex].getDestinationStep());
                                VWBaseRouteUI route = nextStep.hasARouteToStep(prevStep) ? new VWBaseRouteUI(vwRoutes[rIndex], prevStep, nextStep, false, 2, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWBaseRouteUI(vwRoutes[rIndex], prevStep, nextStep, false, 1, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                                route.addFocusListener(this);
                                prevStep.addNextRoute(route, nextStep);
                                nextStep.addPrevRoute(route, prevStep);
                                this.repaint(route.getBounds());
                                this.m_routes.addElement(route);
                            }
                        }
                        this.notifySelectListeners(true);
                    } else {
                        VWDebug.logError("The main map does not have any steps.  It should minimally have a start step.");
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        this.recalculateBounds(0);
        this.repaint();
    }

    public String getCurrentMapName() {
        return this.m_mapDefinition.getName();
    }

    protected void handleMouseClickOrPressEvent(IVWSelectWorkflowItem itemAtLoc) {
        if (itemAtLoc != null) {
            if (itemAtLoc instanceof VWBaseStepUI && !itemAtLoc.getFocus()) {
                IVWSelectWorkflowItem focusItem = this.getItemWithFocus();
                if (focusItem != null) {
                    focusItem.setFocus(false);
                }
                if (!itemAtLoc.getSelect()) {
                    this.clearAllSelectedItems(false);
                }
                itemAtLoc.setFocus(true);
            }
            VWBaseStepUI stepUI = null;
            VWBaseRouteUI routeUI = null;
            if (itemAtLoc instanceof VWBaseStepUI) {
                stepUI = (VWBaseStepUI)itemAtLoc;
                Enumeration myEnum = stepUI.getNextRoutes();
                if (myEnum != null && myEnum.hasMoreElements()) {
                    routeUI = (VWBaseRouteUI)myEnum.nextElement();
                }
            } else if (itemAtLoc instanceof VWBaseRouteUI) {
                routeUI = (VWBaseRouteUI)itemAtLoc;
                stepUI = routeUI.getSrcStep();
            }
            this.clearAllSelectedItems(false);
            if (stepUI != null) {
                stepUI.setFocus(true);
                this.invalidStepRegion(stepUI);
            }
            if (routeUI != null) {
                routeUI.setSelect(true);
            }
            this.notifySelectListeners(true);
        } else {
            this.clearAllSelectedItems(true);
        }
    }

    protected void rubberbandSelectSteps(Rectangle rubberRect) {
        VWBaseStepUI focusStep = null;
        boolean bHadSelectedItem = this.clearAllSelectedItems(false);
        for (int index = 0; index < this.m_steps.size(); ++index) {
            VWBaseStepUI step = (VWBaseStepUI)this.m_steps.elementAt(index);
            if (!step.getImageBounds().intersects(rubberRect)) continue;
            if (focusStep == null) {
                focusStep = step;
                continue;
            }
            Point loc = focusStep.getLocation();
            double deltaX = loc.x - this.m_rubberbandStopLoc.x;
            double deltaY = loc.y - this.m_rubberbandStopLoc.y;
            double focusDist = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
            loc = step.getLocation();
            deltaY = loc.y - this.m_rubberbandStopLoc.y;
            deltaX = loc.x - this.m_rubberbandStopLoc.x;
            double stepDist = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
            if (!(stepDist < focusDist)) continue;
            focusStep = step;
        }
        if (focusStep != null) {
            focusStep.setFocus(true);
            VWBaseRouteUI route = null;
            Enumeration myEnum = focusStep.getNextRoutes();
            if (myEnum != null && myEnum.hasMoreElements()) {
                route = (VWBaseRouteUI)myEnum.nextElement();
                route.setSelect(true);
            }
            this.invalidStepRegion(focusStep);
            this.notifySelectListeners(true);
        } else if (bHadSelectedItem) {
            this.notifySelectListeners(false);
        }
    }
}

